<?php
use TourOperatorPro\Factory;
use TourOperatorPro\Utilities\Utility;
defined('_TOUROPERATOR_EXEC') or die;
extract($displayData);
$id_by_name = "element_field_" . $name;
$data = $field->getForm()->getData();
$a_title = $data->def('name');
$fullname = ucwords($data->def('first_name') . ' ' . $data->def('last_name'));
$image = $data->def('image_location_avatar');
$a_title = Utility::clean($a_title);
$a_title = Utility::clean_all_space_to_single_space($a_title);
$arrName = explode(' ', $a_title);
$arrName = array_splice($arrName, 0, 3);
$iconImg = [];
for ($i = 0; $i < count($arrName); $i++) {
	$iconImg[] = mb_substr($arrName[$i], 0, 1, "UTF-8");
}
$iconImg = implode(" ", $iconImg);
$iconImg = strtoupper($iconImg);
$url=Factory::getRootUrlPlugin().($value ? $value : $default);
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-cover">
        <div class="wrapper-field-cover">
            <div class="header">
                <i class="far fa-plus-square upload"></i>
                <div class="img-block">
                    <div>
                        <img class="img-avatar" src="<?php echo($url) ?>" alt="img-tour">
                    </div>
                </div>
                <span><?php esc_html_e($iconImg) ?></span>
            </div>
            <p><?php esc_html_e($a_title?$a_title:$fullname) ?></p>
            <input type="file" name="<?php echo (esc_attr($name)); ?>" class="upload" style="display: none"/>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStylesheet('admin/app/layouts/WooBooking/form/field/cover/cover.less');
$doc->addScriptApplySelector("#$id_by_name",'field_cover',array(
),'admin/app/layouts/WooBooking/form/field/cover/cover.jquery.js');