<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Utilities\Utility;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Language\Text;
defined('_TOUROPERATOR_EXEC') or die;
extract($displayData);

TourOperatorProHtmlBackendAlias::load_jquery_library('select2');


$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$list_type_field = array('boolean','select','checkbox','text','textarea');

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-typefield">
        <select class="table-view" name="<?php echo (esc_attr($name)); ?>">
            <option value=""><?php esc_attr_e('Select type','touroperatorpro') ?></option>
            <?php foreach ($list_type_field as $type) { ?>
                <option <?php echo ($value == $type ? ' selected ' : '') ?>
                        value="<?php echo (esc_attr($type)) ?>"><?php esc_html_e(ucfirst($type)) ?></option>
            <?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/typefield/typefield.less');
$doc->addScriptApplySelector('.field-typefield','field_typefield',array(
),'admin/app/layouts/WooBooking/form/field/typefield/typefield.jquery.js');