<?php
namespace TourOperatorProAdminWooPanel\app\helpers;

use TourOperatorPro\Factory;
use TourOperatorPro\Filesystem\File;
use TourOperatorPro\Filesystem\Folder;
use TourOperatorPro\Utilities\Utility;

class CustomizeHelper
{
    public static function getListTableView() {
        $db = Factory::getDBO();
        $all_list_table = $db->getTableList();
        $list_table = array();
        foreach ($all_list_table as $table) {
            if(strpos( $table,'tbpro_') !== false) {
                array_push($list_table, $table);
            }
        }
        return $list_table;

    }
    public static function get_list_customize($table){
        $db=Factory::getDBO();
        $query=$db->getQuery(true);
        $query->clear()
            ->select('DISTINCT customize.*')
            ->from(Utility::getTableName('customize'). ' AS customize')
            ->where('customize.table_view='.$query->quote($table))
            ->where('customize.published=1')
        ;
        $list_customize =$db->setQuery($query)->loadObjectList();
        return $list_customize;
    }
    public static function assignValue($list_customize,$item){
        if (!empty($list_customize)) {
            foreach ($list_customize as $customize){
                if (isset($item->{$customize->field_name})) {
                    $customize->value=$item->{$customize->field_name};
                }
            }
        }
        return $list_customize;
    }
}