<?php
namespace TourOperatorProAdminWooPanel\app\helpers;

use TourOperatorPro\Factory;
use TourOperatorPro\Filesystem\File;
use TourOperatorPro\Utilities\Utility;

class AdminHelper
{
    public static $list_key_tour_properties=array(
      'destination'=>"destination",
      'tourtype'=>'tourtype',
      'activity'=>'activity',
      'discount'=>'discount',
      'coupon'=>'coupon',
      'season'=>'season',
    );
    public static function getTourDestinationKey(){
        return self::$list_key_tour_properties['destination'];
    }
    public static function getTourTypeKey(){
        return self::$list_key_tour_properties['tourtype'];
    }
    public static function getTourActivityKey(){
        return self::$list_key_tour_properties['activity'];
    }
    public static function getTourSeasonKey(){
        return self::$list_key_tour_properties['season'];
    }

    public static function getListKeyOfTourProperties(){
        return static::$list_key_tour_properties;
    }
    public static function deletePropertyByKey($key='',$id=0) {
        $db= Factory::getDBO();
        $query=$db->getQuery(true);
        $query->clear()
            ->delete(Utility::getTableName('tourproperty'))
            ->where('object_id='.(int)$id)
            ->where('type='.$query->quote($key))
        ;
        $db->setQuery($query)->execute();

    }
    public static function insertNewPropertyByKey($key='',$properties=array(), $tour_id=0) {
        $db = Factory::getDBO();
        $query =$db->getQuery(true);
        foreach ($properties as $property) {
            $query->clear()
                ->insert(Utility::getTableName('tourproperty'))
                ->set('object_id='.(int)$property)
                ->set('type='.$query->quote($key))
                ->set('tour_id='.(int)$tour_id)
            ;
            $db->setQuery($query)->execute();
        }
    }

    public static function getTourDiscountKey()
    {
        return self::$list_key_tour_properties['discount'];
    }
    public static function getTourCouponKey()
    {
        return self::$list_key_tour_properties['coupon'];
    }
    public static function getDirContents($dir, &$results = array(), $exclude = array(), $filter = array())
    {
        $files = scandir($dir);
        $filter = array_map('strtolower', $filter);
        foreach ($files as $key => $value) {
            if (in_array($value, $exclude)) {
                continue;
            }
            $path = realpath($dir . DIRECTORY_SEPARATOR . $value);
            $extension = strtolower(File::getExt($path));
            if (!is_dir($path)) {
                if (empty($filter)) {
                    $results[] = $path;
                } elseif (in_array($extension, $filter)) {
                    $results[] = $path;
                }
            } else {
                if ($value != "." && $value != "..") {
                    self::getDirContents($path, $results, $exclude, $filter);
                    $results[] = $path;
                }
            }
        }
        return $results;
    }


}