"use strict";
(function ($) {
    $.view_db_appointments_dashboard = function (element, options) {
        let defaults = {
            row_payment_template: "",
            list_order_by_month: []
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let list_order_by_month= plugin.settings.list_order_by_month;
            let labels_month=[];
            let data_by_month=[];
            let data_by_month_amount=[];


            $.each(list_order_by_month, function( index, list_order ) {
                labels_month.push(index);
                let total_amount=0;
                if(list_order.length>0){
                    $.each(list_order, function( index, order ) {
                        total_amount+=parseFloat(order.total);
                    });
                }
                data_by_month.push(list_order.length);
                data_by_month_amount.push(total_amount);
            });



            let data_order_by_Moth = {
                labels: labels_month,
                datasets: [{
                    label: '# total order',
                    data:data_by_month,
                    backgroundColor: [
                        'rgba(255, 99, 132, 0.2)',
                        'rgba(54, 162, 235, 0.2)',
                        'rgba(255, 206, 86, 0.2)',
                        'rgba(75, 192, 192, 0.2)',
                        'rgba(153, 102, 255, 0.2)',
                        'rgba(255, 159, 64, 0.2)'
                    ],
                    borderColor: [
                        'rgba(255, 99, 132, 1)',
                        'rgba(54, 162, 235, 1)',
                        'rgba(255, 206, 86, 1)',
                        'rgba(75, 192, 192, 1)',
                        'rgba(153, 102, 255, 1)',
                        'rgba(255, 159, 64, 1)'
                    ],
                    borderWidth: 1
                }]
            }
            let data_order_by_total_amount = {
                labels: labels_month,
                datasets: [{
                    label: '# monthly profits',
                    data:data_by_month_amount,
                    backgroundColor: [
                        'rgba(255, 99, 132, 0.2)',
                        'rgba(54, 162, 235, 0.2)',
                        'rgba(255, 206, 86, 0.2)',
                        'rgba(75, 192, 192, 0.2)',
                        'rgba(153, 102, 255, 0.2)',
                        'rgba(255, 159, 64, 0.2)'
                    ],
                    borderColor: [
                        'rgba(255, 99, 132, 1)',
                        'rgba(54, 162, 235, 1)',
                        'rgba(255, 206, 86, 1)',
                        'rgba(75, 192, 192, 1)',
                        'rgba(153, 102, 255, 1)',
                        'rgba(255, 159, 64, 1)'
                    ],
                    borderWidth: 1
                }]
            }
            let data = {
                labels: ['Red', 'Blue', 'Yellow', 'Green', 'Purple', 'Orange'],
                datasets: [{
                    label: '# of Votes',
                    data: [12, 19, 3, 5, 2, 3],
                    backgroundColor: [
                        'rgba(255, 99, 132, 0.2)',
                        'rgba(54, 162, 235, 0.2)',
                        'rgba(255, 206, 86, 0.2)',
                        'rgba(75, 192, 192, 0.2)',
                        'rgba(153, 102, 255, 0.2)',
                        'rgba(255, 159, 64, 0.2)'
                    ],
                    borderColor: [
                        'rgba(255, 99, 132, 1)',
                        'rgba(54, 162, 235, 1)',
                        'rgba(255, 206, 86, 1)',
                        'rgba(75, 192, 192, 1)',
                        'rgba(153, 102, 255, 1)',
                        'rgba(255, 159, 64, 1)'
                    ],
                    borderWidth: 1
                }]
            }
            let myChart = new Chart($element.find('.order-this-week'), {
                type: 'bar',
                data: data_order_by_Moth,
                options: {
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero: true
                            }
                        }]
                    }
                }
            });
            let employee_chart = new Chart($element.find('.employee-chart'), {
                type: 'bar',
                data: data_order_by_total_amount,
                options: {
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero: true
                            }
                        }]
                    }
                }
            });
            let finance_chart = new Chart($element.find('.finance-chart'), {
                type: 'line',
                data: data,
                options: {
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero: true
                            }
                        }]
                    }
                }
            });
            let finance_chart_pie = new Chart($element.find('.finance-chart-pie'), {
                type: 'pie',
                data: data,
                options: {
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero: true
                            }
                        }]
                    }
                }
            });
            $element.find('.tab-booking').responsiveTabs();
            $element.find('.tab-booking-order').responsiveTabs();
        };
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_db_appointments_dashboard = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_db_appointments_dashboard')) {
                let plugin = new $.view_db_appointments_dashboard(this, options);
                $(this).data('view_db_appointments_dashboard', plugin);
            }
        });
    }
})(jQuery);
