<?php

namespace TourOperatorProAdmin\app\views\tourtype;

use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Mvc\View\View;
use TourOperatorPro\Factory as FactoryAlias;

class TourtypeView extends View
{
    public function display($tpl)
    {
        $modelTourtype = Model::getInstance("tourtype");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("tourtype.add");
                ToolBar::delete("tourtype.delete_list");
                ToolBar::_clone('tourtype.clone_list');
                $model = Model::getInstance("tourtypes");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit Tour type');
                ToolBar::save("tourtype.save");
                ToolBar::apply('tourtype.apply');
                ToolBar::cancel('tourtype.cancel');
                ToolBar::back_to_list('tourtype.back_to_list');
                $id = $input->getInt('id', 0);
                $this->item = $modelTourtype->getItem($id);
                $this->form = $modelTourtype->getForm();
                break;
        }
        return parent::display($tpl);
    }
}