<?php

use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Utilities\Utility as UtilityAlias;
use TourOperatorProAdmin\app\helpers\CurrencyHelper;
use TourOperatorProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
TourOperatorProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List tour");
TourOperatorProHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("tours.form")) ?>" name="admin-form" method="post">
        <div class="view-list-tours">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_attr_e('index','touroperatorpro'); ?><?php echo (HtmlBackend::render_check_all('item')) ?></th>
                        <th ><?php esc_attr_e('Tour name','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Tour type','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Price','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Adult price','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Children price','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Infant price','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Destination','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Id','touroperatorpro'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="no-wrap tour-name nowrap"><h4><?php echo ($item->name); ?></h4></td>
                        <td class="tour-type ">
                        <?php foreach ($item->list_tour_type as $tour_type){ ?>
                            <?php echo "$tour_type->name <br/>" ?>
                        <?php } ?>
                        </td>
                        <td class="price price-refer">
                            <span>
                                <?php echo (CurrencyHelper::convertSymbols(CurrencyHelper::convertCurrency($item->price))); ?>
                            </span>
                        </td>
                        <td class="price adult-price">
                            <span>
                                <?php echo (CurrencyHelper::convertSymbols(CurrencyHelper::convertCurrency($item->adult_price)));?>
                            </span>
                        </td>
                        <td class="price children-price">
                            <span>
                                <?php echo (CurrencyHelper::convertSymbols(CurrencyHelper::convertCurrency($item->children_price)));?>
                            </span>
                        </td>
                        <td class="price infant-price">
                            <?php  echo (CurrencyHelper::convertSymbols(CurrencyHelper::convertCurrency($item->infant_price)));?>
                        </td>
                        <td class="tour-destination">
                            <?php foreach ($item->list_destination as $destination){ ?>
                                <?php echo ($destination->address) ?>
                                <br/>
                            <?php } ?>
                        </td>
                        <td><?php echo ($item->id); ?></td>
                        <td class="tour-action nowrap">
                            <a href="<?php echo(UtilityAlias::getBackendGoToLink("tours.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','touroperatorpro')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByView("tours","tour.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','touroperatorpro')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet("admin_woopanel/app/assets/less/view_list_tours.less");
$doc->addScriptApplySelector('.view-list-tours', 'view_list_tours', array(

), "admin_woopanel/app/assets/js/view_list_tours.js");
?>