<?php

namespace TourOperatorProAdmin\app\views\tours;

use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Mvc\View\View;
use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorProAdmin\app\helpers\CustomizeHelper;

class ToursView extends View
{
    public function display($tpl)
    {

        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("tour.add");
                ToolBar::delete("tour.delete_list");
                ToolBar::_clone("tour.clone_list");
                $model = Model::getInstance("tours");
                $this->list = $model->getList();
                break;
            case "form":
                $modelTour = Model::getInstance("tour");
                ToolBar::setTitle('Edit Tour');
                ToolBar::apply("tour.apply");
                ToolBar::save("tour.save");
                ToolBar::cancel("tour.cancel");
                ToolBar::back_to_list("tour.back_to_list");

                $id = $input->getInt('id', 0);
                $this->item = $modelTour->getItem($id);
                $this->form = $modelTour->getForm();
                $this->list_customize=CustomizeHelper::get_list_customize("tour");
                $this->list_customize=CustomizeHelper::assignValue( $this->list_customize,$this->item);
                break;
        }
        return parent::display($tpl);
    }
}