<?php

use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Utilities\Utility as UtilityAlias;
use TourOperatorProAdmin\app\helpers\CurrencyHelper;
use TourOperatorProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
TourOperatorProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List Payment");
TourOperatorProHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("payment.form")) ?>" name="admin-form" method="post">
        <div class="view-list-payment">
            <table id="example" class="display table">
                <thead>
                <tr>
                    <th><?php esc_html_e('Index','touroperatorpro'); ?></th>
                    <th class="view-list-payment-th nowrap"><?php esc_html_e('Name','touroperatorpro') ?></th>
                    <th class="view-list-payment-th nowrap"><?php esc_html_e('Image','touroperatorpro') ?></th>
                    <th class="view-list-payment-th nowrap"><?php esc_html_e('Payment type','touroperatorpro') ?></th>
                    <th class="view-list-payment-th nowrap"><?php esc_html_e('ID','touroperatorpro') ?></th>
                    <th class="view-list-payment-th nowrap"><?php esc_html_e('Status','touroperatorpro') ?></th>
                    <th class="view-list-payment-th nowrap"><?php esc_html_e('action','touroperatorpro') ?></th>
                    <th class="nowrap"></th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="name nowrap"><?php echo (esc_html($item->name)) ?></td>
                        <td class="image nowrap">
                            <div class="img-box">
                                <img class="payment-image" src="<?php echo (esc_attr(FactoryAlias::getRootUrlPlugin())) ?>/<?php echo (esc_attr($item->image)) ?>" alt="payment-image" />
                            </div>
                        </td>
                        <td class="name nowrap"><?php echo (esc_html($item->type)) ?></td>
                        <td class="id nowrap"><?php echo (esc_html($item->id)) ?></td>
                        <td class="nowrap">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="<?php esc_attr_e('Public','touroperatorpro') ?> "></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="<?php esc_attr_e('Not public','touroperatorpro') ?> "></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="payment-action">
                            <a href="<?php echo(UtilityAlias::getBackendGoToLink("payment.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','touroperatorpro')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByView("payment","payment.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','touroperatorpro')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet("admin/app/assets/less/view_list_payments.less");
$doc->addScriptApplySelector('.view-list-payment', 'view_list_payment', array(
), "admin/app/assets/js/view_list_payments.js");
?>