<?php
use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\TourOperatorProHtmlBackend;
use TourOperatorProAdmin\app\HtmlCustomField\HtmlCustomFieldBackend;
use TourOperatorPro\Language\Text;
$doc= FactoryAlias::getDocument();
TourOperatorProHtmlBackend::daterangepicker();

?>
<div id="view-payment-block" class="view-payment-form">
    <form action="" method="post" name="admin-form" enctype="multipart/form-data">
        <div>
            <ul class="state-tab nav nav-tabs" role="tablist">
                <li role="presentation" class="active">
                    <a href="#detail" aria-controls="detail" role="tab" data-toggle="tab">
                        <?php esc_html_e('Payment details','touroperatorpro') ?>
                    </a>
                </li>
                <li role="presentation">
                    <a href="#settings" aria-controls="settings" role="tab" data-toggle="tab">
                        <?php esc_html_e('Payments setting','touroperatorpro') ?>
                    </a>
                </li>
            </ul>
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="detail">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('image')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('name')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('open_source_payment_id')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('published')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('debug')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('is_payment_online')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('description')) ?>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="settings">
                   <?php
                    $type = $this->item->type;
                    if (isset($this->item->params) && !empty($this->item->params)){
                    $this->element = new stdClass();
                    $this->element->payment_params = $this->item->params->get('payment_params', "");
                    $configuration_file = TOUROPERATORPRO_PATH_ROOT . "lib/payments/$type/{$type}_configuration.php";
                    ?>
                    <?php if (file_exists($configuration_file)) {?>
                        <table class="table table-bordered">
                            <?php echo require_once ($configuration_file) ?>
                        </table>
                   <?php } ?>
                   <?php } ?>
                </div>
            </div>
        </div>
        <?php echo ($this->form->renderField('id')) ?>
        <input type="hidden" name="task" value="state.save">
    </form>
</div>

<?php
?>
