<?php
use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Utilities\Utility as UtilityAlias;
use TourOperatorProAdmin\app\Html\HtmlBackend;
use TourOperatorPro\Language\Text;
$doc = FactoryAlias::getDocument();
$doc->addLessStyleSheet('admin/app/assets/less/view_list_orders.less');
TourOperatorProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List order");
TourOperatorProHtmlBackendAlias::load_jquery_library('datatables');
?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("orders.form")) ?>" name="admin-form" method="post">
        <div class="view-list-orders">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_attr_e('Index','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Order number','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Customer','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Information','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Delete','touroperatorpro'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="order-number"><?php esc_html_e($item->id); ?></td>
                        <td class="customer"><?php esc_html_e($item->customer_full_name); ?></td>
                        <td class="order-action">
                            <a href="<?php echo(UtilityAlias::getBackendGoToLink("orders.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','touroperatorpro')?>"><button type="button" class="btn btn-info"><?php esc_attr_e('View Order','touroperatorpro'); ?></button></a>
                        </td>
                        <td class="order-action">
                            <a href="<?php echo(UtilityAlias::goToTaskByView("orders","order.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','touroperatorpro')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addScriptApplySelector('.view-list-orders', 'view_list_orders', array(

), "admin/app/assets/js/view_list_orders.js");
?>