<?php
use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Utilities\Utility as UtilityAlias;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorProAdmin\app\helpers\CurrencyHelper;
use TourOperatorProAdmin\app\Html\HtmlBackend;
$doc = FactoryAlias::getDocument();
TourOperatorProHtmlBackendAlias::load_jquery_library('icheck');
TourOperatorProHtmlBackendAlias::load_jquery_library('select2');
TourOperatorProHtmlBackendAlias::load_jquery_library('loading_js');
TourOperatorProHtmlBackendAlias::load_jquery_library('datatables');
$doc->addScriptApplySelector('.view-order-form', 'view_order_form', array(
), "admin/app/assets/js/view_form_order.js");
$doc->addLessStyleSheet('admin/app/assets/less/view_order_form.less');
?>
<div class="view-order-form">
    <form action="" name="admin-form" method="post" enctype="multipart/form-data">
        <table class="table table-bordered" data-order_id="<?php esc_html_e($this->item->order_detail->id) ?>">
            <tr>
                <th width="40%"><?php esc_attr_e('Order id','touroperatorpro'); ?></th>
                <td><?php esc_html_e($this->item->id); ?></td>
            </tr>

            <tr>
                <th><?php esc_attr_e('Edit Orders','touroperatorpro'); ?></th>
                <td> <a href="<?php echo(UtilityAlias::getBackendGoToLink("orders.edit",array('id'=>$this->item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','touroperatorpro')?>"><button type="button" class="btn btn-primary"><i class="fas fa-edit"></i><?php esc_attr_e('Edit Order','touroperatorpro'); ?></button></a>
                </td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Customer name','touroperatorpro'); ?></th>
                <td><?php isset($this->item->customer->full_name)?esc_html_e($this->item->customer->full_name):''; ?></td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Tour name','touroperatorpro'); ?></th>
                <td><?php isset($this->item->tour->name)?esc_html_e($this->item->tour->name):''; ?></td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Mobile','touroperatorpro'); ?></th>
                <td><?php isset($this->item->customer->mobile)?esc_html_e($this->item->customer->mobile):''; ?>
                </td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Country','touroperatorpro'); ?></th>
                <td><?php isset($this->item->customer->countryname)?esc_html_e($this->item->customer->countryname):''; ?></td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Check in','touroperatorpro'); ?></th>
                <td><?php echo (isset($this->item->order_detail->start_date)?HtmlBackend::render_date($this->item->order_detail->start_date):''); ?></td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Adult','touroperatorpro'); ?></th>
                <td><?php echo (isset($this->item->order_detail->adult)?esc_html_e($this->item->order_detail->adult):''); ?></td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Children','touroperatorpro'); ?></th>
                <td><?php echo (isset($this->item->order_detail->children)?esc_html_e($this->item->order_detail->children):''); ?></td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Infant','touroperatorpro'); ?></th>
                <td><?php echo (isset($this->item->order_detail->infant)?esc_html_e($this->item->order_detail->infant):''); ?></td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Note','touroperatorpro'); ?></th>
                <td><?php echo (isset($this->item->customer->note_internal)?esc_html_e($this->item->customer->note_internal):''); ?></td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Total','touroperatorpro'); ?></th>
                <td><?php echo (isset($this->item->order_detail->total)?esc_html_e(CurrencyHelper::convertSymbols(CurrencyHelper::convertCurrency($this->item->order_detail->total))):''); ?></td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Change order status','touroperatorpro'); ?></th>
                <td>
                    <?php
                    $field = $this->form->getField('order_status_id');
                    ?>
                    <?php echo ($field->input) ?>

                </td>
            </tr>
        </table>
        <?php echo ($this->form->renderField('id')) ?>
        <input type="hidden" name="task" value="order.save">
    </form>
</div>
