<?php
use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorProAdmin\app\helpers\CurrencyHelper;
use TourOperatorProAdmin\app\Html\HtmlBackend;
$doc = FactoryAlias::getDocument();
TourOperatorProHtmlBackendAlias::load_jquery_library('icheck');
TourOperatorProHtmlBackendAlias::load_jquery_library('select2');
TourOperatorProHtmlBackendAlias::load_jquery_library('loading_js');
TourOperatorProHtmlBackendAlias::load_jquery_library('datatables');
TourOperatorProHtmlBackendAlias::load_jquery_library('datepickertime');
$doc->addScriptApplySelector('.view-edit-form', 'view_edit_form', array(
    'customer' => $this->item->customer,
    'lastname' => array(
         'current' => isset($this->item->customer->last_name)?($this->item->customer->last_name):'',
    ),
    'tour' => $this->item->tour,
    'group_size' => isset($this->item->tour->group_size) ? (int)$this->item->tour->group_size : 0,
    'adult' => array(
        'min' => 0,
        'max' => 10,
        'current' => isset($this->item->order_detail->adult)  ? (int)$this->item->order_detail->adult: 0,
        'price' => isset($this->item->tour->adult_price) ? CurrencyHelper::convertCurrency((float)$this->item->tour->adult_price) : 0
    ),
    'children' => array(
        'min' => 0,
        'max' => 10,
        'current' => isset($this->item->order_detail->children)  ? (int)$this->item->order_detail->children: 0,
        'price' => isset($this->item->tour->children_price) ? CurrencyHelper::convertCurrency((float)$this->item->tour->children_price): 0
    ),
    'infant' => array(
        'min' => 0,
        'max' => 10,
        'current' => isset($this->item->order_detail->infant)  ? (int)$this->item->order_detail->infant: 0,
        'price' => isset($this->item->tour->infant_price) ? CurrencyHelper::convertCurrency((float)$this->item->tour->infant_price): 0
    ),
    'format_currency' => $this->currency
), "admin/app/assets/js/view_edit_order.js");
$doc->addLessStyleSheet('admin/app/assets/less/view_edit_orders.less');
?>
<div class="view-edit-form">
    <form action="" name="admin-form" method="post" enctype="multipart/form-data">
        <table class="table table-bordered" data-order_id="<?php esc_html_e($this->item->order_detail->id) ?>" data-customer_id="<?php esc_html_e($this->item->customer->id) ?>">
            <input type="hidden" name="customer_id" value="<?php esc_html_e($this->item->customer->id) ?>">
            <input type="hidden" name="ordertail_id" value="<?php esc_html_e($this->item->order_detail->id) ?>">
            <input type="hidden" name="tour_id" value="<?php esc_html_e($this->item->tour->id) ?>">
            <tr>
                <th width="40%"><?php esc_attr_e('Order id','touroperatorpro'); ?></th>
                <td><?php esc_html_e($this->item->id); ?></td>
            </tr>
            <tr>
                <th><?php esc_attr_e('First Name','touroperatorpro'); ?></th>
                <td>
                    <div data-group_name="firstname" class="form-group clearfix lastname group-firstname">
                        <div class="guest-wrapper">
                            <div class="select-wrapper">
                                <input type="text" class="inputfirstname" name="first_name"  value="<?php isset($this->item->customer->first_name)?esc_html_e($this->item->customer->first_name):''; ?>" placeholder=""  />
                            </div>
                        </div>
                    </div>
                </td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Last Name','touroperatorpro'); ?></th>
                <td>
                    <div data-group_name="lastname" class="form-group clearfix lastname group-lastname">
                        <div class="guest-wrapper">
                            <div class="select-wrapper">
                                <input type="text" class="inputlastname" name="last_name"  value="<?php isset($this->item->customer->last_name)?esc_html_e($this->item->customer->last_name):''; ?>" placeholder=""  />
                            </div>
                        </div>
                    </div>
                </td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Tour name','touroperatorpro'); ?></th>
                <td class="nowrap">
                    <div class="list-order-status">
                        <select class="order-status">
                            <?php foreach ($this->list_tour as $list_tour) {?>
                                <option <?php echo( (isset($this->item->tour->name)&&$list_tour->id == $this->item->tour->id ) ? ' selected ' : '') ?>
                                    value="<?php esc_html_e($list_tour->id); ?>"><?php esc_html_e($list_tour->name); ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Mobile','touroperatorpro'); ?></th>
                <td>
                    <div class="form-group">
                        <textarea class="form-control mobile" name="mobile" id="mobile" rows="1"><?php echo (isset($this->item->customer->mobile)?esc_html_e($this->item->customer->mobile):''); ?></textarea>
                    </div>
                </td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Country','touroperatorpro'); ?></th>
                <td>
                    <div class="list-countries-select">
                        <select class="list-countries">
                            <?php foreach ($this->list_country as $countries) {?>
                                <option <?php echo((isset($this->item->customer->countryname)&&$countries->countryname == $this->item->customer->countryname ) ? ' selected ' : '') ?>
                                        value="<?php esc_html_e($countries->code); ?>"><?php esc_html_e($countries->countryname); ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Check in','touroperatorpro'); ?></th>
                <td>
                    <div class="input-append date form_datetime">
                        <input type="text" class="form-control time-booking" name="form_datetime" value="<?php echo ($this->item->customer->created_date)?>">
                        <span class="add-on"><i class="icon-remove icon-nb-close"></i></span>
                        <span class="add-on"><i class="icon-calendar icon-nb-calendar"></i></span>
                    </div>
                    <input type="hidden" class="mirror_field" name="order_edit">
                </td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Group size','touroperatorpro'); ?></th>
                <td><?php echo isset($this->item->tour->group_size)?esc_html_e($this->item->tour->group_size):'';?></td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Adult','touroperatorpro'); ?></th>
                <td>
                    <div data-group_key="adult" class="form-group clearfix adult group-adult-children-infant">
                        <div class="guest-wrapper">
                            <div class="select-wrapper">
                                <i class="fas fa-minus"></i>
                                <input class="input-adult" type="text" value="<?php echo (isset($this->item->order_detail->adult)?esc_html_e($this->item->order_detail->adult):''); ?>">
                                <input type="hidden" name="adult_number" value="<?php echo (isset($this->item->order_detail->adult)?esc_html_e($this->item->order_detail->adult):''); ?>">
                                <i class="fas fa-plus"></i>
                            </div>
                        </div>
                    </div>
                </td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Children','touroperatorpro'); ?></th>
                <td>
                    <div data-group_key="children"
                         class="form-group clearfix children group-adult-children-infant">
                        <div class="guest-wrapper">
                            <div class="select-wrapper">
                                <i class="fas fa-minus"></i>
                                <input class="input-children" type="text" value="<?php echo (isset($this->item->order_detail->children)?esc_html_e($this->item->order_detail->children):''); ?>">
                                <input type="hidden" name="children_number" value="<?php echo (isset($this->item->order_detail->children)?esc_html_e($this->item->order_detail->children):''); ?>">
                                <i class="fas fa-plus"></i>
                            </div>
                        </div>
                    </div>
                </td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Infant','touroperatorpro'); ?></th>
                <td>
                    <div data-group_key="infant" class="form-group clearfix infant group-adult-children-infant">
                        <div class="guest-wrapper">
                            <div class="select-wrapper">
                                <i class="fas fa-minus"></i>
                                <input class="input-infant" type="text" value="<?php echo (isset($this->item->order_detail->infant)?esc_html_e($this->item->order_detail->infant):''); ?>">
                                <input type="hidden" name="infant_number" value="<?php echo (isset($this->item->order_detail->infant)?esc_html_e($this->item->order_detail->infant):''); ?>">
                                <i class="fas fa-plus"></i>
                            </div>
                        </div>
                    </div>
                </td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Note','touroperatorpro'); ?></th>
                <td>
                    <div class="form-group">
                        <textarea class="form-control description" id="description" name="description"  rows="3"><?php echo(isset($this->item->customer->note_internal)?esc_html_e($this->item->customer->note_internal):''); ?></textarea>
                    </div>
                </td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Total','touroperatorpro'); ?></th>
                <td>
                    <textarea class="form-control total-price" id="total-price" name="total_price"  rows="1" disabled><?php echo (isset($this->item->order_detail->total)?esc_html_e(CurrencyHelper::convertSymbols(CurrencyHelper::convertCurrency($this->item->order_detail->total))):''); ?></textarea>
                </td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Change order status','touroperatorpro'); ?></th>
                <td>
                    <?php
                    $field = $this->form->getField('order_status_id');
                    ?>
                    <?php echo ($field->input) ?>

                </td>
            </tr>
        </table>
        <input type="hidden" name="task" value="">
        <?php echo ($this->form->renderField('id')) ?>
    </form>
</div>
