<?php

namespace TourOperatorProAdmin\app\views\orders;

use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Mvc\View\View;
use TourOperatorPro\Factory as FactoryAlias;

class OrdersView extends View
{
    public function display($tpl)
    {
        $modelTour = Model::getInstance("order");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "form":
                ToolBar::setTitle('Edit order');
                ToolBar::cancel("order.cancel");
                ToolBar::back_to_list("order.back_to_list");
                $model = Model::getInstance("order");
                $modeldetail = Model::getInstance("order");
                $oder_id = $input->getInt('id');
                $modelListTour = Model::getInstance('tours');
                $this->list_tour = $modelListTour->getList();
                $this->item = $model->getItem($oder_id);
                $this->form = $model->getForm();
                break;
            case "list":
                ToolBar::delete("order.delete_list");
                $model = Model::getInstance("orders");
                $this->list = $model->getList();
                break;
            case "edit":
                ToolBar::save("order.save");
                ToolBar::setTitle('Edit order');
                ToolBar::cancel("order.cancel");
                ToolBar::back_to_list("order.back_to_list");
                $appConfig = FactoryAlias::getAppConfig();
                $based = $appConfig->get('currencies_in_list','');
                $currencyModel = Model::getInstance('currency');
                $symbol = $currencyModel->format_currency($based);
                $this->currency = reset($symbol);
                $model = Model::getInstance("order");
                $oder_id = $input->getInt('id');
                $modelListTour = Model::getInstance('tours');
                $modelListCountry = Model::getInstance('countries');
                $this->list_country = $modelListCountry->getList();
                $this->list_tour = $modelListTour->getList();
                $this->item = $model->getItem($oder_id);
                $this->form = $model->getForm();
                break;
        }
        return parent::display($tpl);
    }
}