<?php

use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Utilities\Utility as UtilityAlias;
use TourOperatorProAdmin\app\Html\HtmlBackend;
use TourOperatorPro\Language\Text;
$doc = FactoryAlias::getDocument();
TourOperatorProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List Itineraries");
TourOperatorProHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("itineraries.form")) ?>" name="admin-form" method="post">
        <div class="view-list-itineraries">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_attr_e('Index','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Itinerary name','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Tour name','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Description','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Publish','touroperatorpro'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="itinerary-name">
                            <h4><?php echo ($item->name); ?></h4>
                        </td>
                        <td class="tour-name"><?php echo ($item->tour_name); ?></td>
                        <td class="itinerary-description">
                            <div><?php echo ($item->description); ?></div>
                        </td>
                        <td class="itinerary-published">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="Public"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="Not-Public"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="itinerary-action">
                            <a href="<?php echo(UtilityAlias::getBackendGoToLink("itineraries.form",array("id"=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','touroperatorpro')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByView('itineraries','itinerary.delete',array("id"=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','touroperatorpro')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="itineraries.add">
    </form>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_itinerary.less');
$doc->addScriptApplySelector('.view-list-itineraries', 'view_list_itineraries', array(

), "admin_woopanel/app/assets/js/view_list_itineraries.js");
?>