<?php

namespace TourOperatorProAdmin\app\views\itineraries;

use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Mvc\View\View;
use TourOperatorPro\Factory as FactoryAlias;

class ItinerariesView extends View
{
    public function display($tpl)
    {
        $modelitinerary = Model::getInstance("itinerary");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("itinerary.add");
                ToolBar::delete("itinerary.delete_list");
                ToolBar::_clone("itinerary.clone_list");
                $model = Model::getInstance("itineraries");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit itinerary');
                ToolBar::apply("itinerary.apply");
                ToolBar::save("itinerary.save");
                ToolBar::cancel("itinerary.cancel");
                ToolBar::back_to_list("itinerary.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelitinerary->getItem($id);
                $this->form = $modelitinerary->getForm();
                break;
        }
        return parent::display($tpl);
    }
}