<?php

use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Utilities\Utility as UtilityAlias;
use TourOperatorProAdmin\app\Html\HtmlBackend;
use TourOperatorPro\Language\Text;
$doc = FactoryAlias::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_facilities.less');
TourOperatorProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List Facilities");
TourOperatorProHtmlBackendAlias::load_jquery_library('datatables');
?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("facilities.form")) ?>" name="admin-form" method="post">
        <div class="view-list-facilities">
            <table id="example" class="display table">
                <thead>
                <tr>
                    <th><?php esc_attr_e('Index','touroperatorpro'); ?></th>
                    <th><?php esc_attr_e('Facility name','touroperatorpro'); ?></th>
                    <th><?php esc_attr_e('Image','touroperatorpro'); ?></th>
                    <th><?php esc_attr_e('Description','touroperatorpro'); ?></th>
                    <th></th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($this->list as $item) { ?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="facility-name">
                            <h4><?php echo ($item->name); ?></h4>
                        </td>
                        <td class="facility-image">
                            <div class="img-box">
                                <div>
                                    <img src="<?php esc_html_e(FactoryAlias::getRootUrlPlugin()) ?>/<?php echo ($item->image); ?>">
                                </div>
                            </div>
                        </td>
                        <td class="facility-description">
                            <div>
                                <?php echo ($item->description); ?>
                            </div>
                        </td>
                        <td class="facility-action">
                            <a href="<?php echo(UtilityAlias::getBackendGoToLink("facilities.form", array("id" => $item->id))) ?>"
                               class="btn-edit" title="<?php esc_attr_e('Edit','touroperatorpro')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByView("facilities", 'facility.delete', array("id" => $item->id))) ?>"
                               class="btn-delete" title="<?php esc_attr_e('Delete','touroperatorpro')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="facility.save">
    </form>
<?php
$doc->addScriptApplySelector('.view-list-facilities', 'view_list_facilities', array(), "admin_woopanel/app/assets/js/view_list_facilities.js");
?>