<?php

namespace TourOperatorProAdmin\app\views\facilities;

use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Mvc\View\View;
use TourOperatorPro\Factory as FactoryAlias;

class FacilitiesView extends View
{
    public function display($tpl)
    {
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("facility.add");
                ToolBar::delete("facility.delete_list");
                ToolBar::_clone("facility.clone_list");
                $model = Model::getInstance("facilities");
                $this->list = $model->getList();
                break;
            case "form":
                $modelFacility = Model::getInstance("facility");
                ToolBar::setTitle('Edit Facility');
                ToolBar::apply("facility.apply");
                ToolBar::save("facility.save");
                ToolBar::cancel("facility.cancel");
                ToolBar::back_to_list("facility.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelFacility->getItem($id);
                $this->form = $modelFacility->getForm();
                break;
        }
        return parent::display($tpl);
    }
}