<?php

use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Utilities\Utility as UtilityAlias;
use TourOperatorProAdmin\app\helpers\EmailHelper;
use TourOperatorProAdmin\app\Html\HtmlBackend;
use TourOperatorPro\Language\Text;
$doc = FactoryAlias::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_emails.less');
TourOperatorProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("Emails");
TourOperatorProHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("emails.form")) ?>" name="admin-form" method="post">
        <div class="view-list-emails">
            <table id="example" class="display table" >
                <thead>
                    <tr>
                        <th><?php esc_attr_e('Index','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Email name','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Type','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Description','touroperatorpro'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="email-name">
                            <h4><?php echo ($item->name); ?></h4>
                        </td>
                        <td class="email-type"><?php esc_html_e(str_replace(" ", "-",$item->type)); ?></td>
                        <td class="email-description">
                            <div>
                                <?php esc_html_e($item->description); ?>
                            </div>
                        </td>
                        <td class="email-action">
                            <a href="<?php echo(UtilityAlias::getBackendGoToLink("emails.form",array("id"=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','touroperatorpro')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByView("emails",'email.delete',array("id"=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','touroperatorpro')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addScriptApplySelector('.view-list-emails', 'view_list_emails', array(

), "admin_woopanel/app/assets/js/view_list_emails.js");
?>