<?php

namespace TourOperatorProAdmin\app\views\emails;

use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Mvc\View\View;
use TourOperatorPro\Factory as FactoryAlias;

class EmailsView extends View
{
    public function display($tpl)
    {
        $modelTour = Model::getInstance("email");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("email.add");
                ToolBar::delete("email.delete_list");
                ToolBar::_clone("email.clone_list");
                ToolBar::edit("email.edit");
                $model = Model::getInstance("emails");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit Email');
                ToolBar::apply("email.apply");
                ToolBar::save("email.save_v1");
                ToolBar::cancel("email.cancel");
                ToolBar::back_to_list("email.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelTour->getItem($id);
                $this->form = $modelTour->getForm();
                break;
        }
        return parent::display($tpl);
    }
}