<?php

use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Utilities\Utility as UtilityAlias;
use TourOperatorPro\Language\Text;
use  TourOperatorProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
TourOperatorProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List sms content");
TourOperatorProHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("emailaccount.form")) ?>" name="admin-form" method="post">
        <div class="view-list-emailaccount">
            <table id="example" class="display table">
                <thead>
                <tr>
                    <th class="nowrap"></th>
                    <th class="nowrap"><?php esc_html_e('ID','touroperatorpro')?></th>
                    <th class="nowrap"><?php esc_html_e('Mailer','touroperatorpro')?></th>
                    <th class="nowrap"><?php esc_html_e('Port','touroperatorpro')?></th>
                    <th class="nowrap"><?php esc_html_e('Host','touroperatorpro')?></th>
                    <th class="nowrap"><?php esc_html_e('Gmail','touroperatorpro')?></th>
                    <th class="nowrap"><?php esc_html_e('App passwords','touroperatorpro')?></th>
                    <th class="nowrap"><?php esc_html_e('Action','touroperatorpro')?></th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="sms-content-id nowrap"><?php echo (esc_html($item->id)); ?></td>
                        <td class="action-sms nowrap"><?php echo (esc_html($item->mailer)); ?></td>
                        <td class="title-sms nowrap"><?php echo (esc_html($item->port)); ?></td>
                        <td class="title-sms nowrap"><?php echo (esc_html($item->host)); ?></td>
                        <td class="content-sms nowrap"><?php echo (esc_html($item->username)); ?></td>
                        <td class="content-sms nowrap"><?php echo (esc_html($item->password)); ?></td>
                        <td class="sms-content-action">
                            <a href="<?php echo(UtilityAlias::getBackendGoToLink("emailaccount.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','touroperatorpro')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByView("emailaccount","emailaccount.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','touroperatorpro')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/view_list_emailaccount.less');
$doc->addStyleSheet('admin/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-emailaccount', 'view_list_emailaccount', array(

), "admin/app/assets/js/view_list_emailaccount.js");
?>