<?php

namespace TourOperatorProAdmin\app\views\dashboard;

use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Mvc\View\View;
use TourOperatorPro\Factory as FactoryAlias;

class DashboardView extends View
{
    public function display($tpl)
    {
        $modelTours = Model::getInstance("tours");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
            default:
                $tpl = "list";
                $modelCustomers = Model::getInstance('customers');
                $this->list_customer = $modelCustomers->get_list_customer_in_year();
                $modelActivities=Model::getInstance('activities');
                $this->list_activities=$modelActivities->getList_activity_public();
                $modelOrders = Model::getInstance('orders');
                $list_order_in_year = $modelOrders->get_list_order_in_year();
                $list_order_by_month = array();
                foreach ($list_order_in_year as $item) {
                    $list_order_by_month[$item->month][] = $item;
                }

                $now = FactoryAlias::getDate();
                $month = (int)$now->format('m');
                $list_full_order_year = array();
                for ($i = $month; $i < $month + 12; $i++) {
                    {
                        $j = $i;
                        if ($j > 12) {
                            $j = $j - 12;
                        }
                        $key = "month $j";
                        if (isset($list_order_by_month[$j])) {
                            $list_full_order_year[$key] = $list_order_by_month[$j];
                        } else {
                            $list_full_order_year[$key] = array();
                        }
                    }
                }
                $this->list_order_by_month = $list_full_order_year;
                $this->list_order_in_year = $list_order_in_year;

                break;
        }
        return parent::display($tpl);
    }
}