<?php

namespace TourOperatorProAdmin\app\views\customize;

use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Mvc\View\View;
use TourOperatorPro\Factory as FactoryAlias;

class CustomizeView extends View
{
    public function display($tpl)
    {
        $modelcustomize = Model::getInstance("customize");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("customize.add");
                ToolBar::delete("customize.delete_list");
                ToolBar::_clone("customize.clone_list");
                $model = Model::getInstance("customizes");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit customize');
                ToolBar::apply("customize.apply");
                ToolBar::save("customize.save");
                ToolBar::cancel("customize.cancel");
                ToolBar::back_to_list("customize.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelcustomize->getItem($id);
                $this->form = $modelcustomize->getForm();

                break;
        }
        return parent::display($tpl);
    }
}