<?php

namespace TourOperatorProAdmin\app\views\customers;

use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Mvc\View\View;
use TourOperatorPro\Factory as FactoryAlias;

class CustomersView extends View
{
    public function display($tpl)
    {
        $modelCustomer = Model::getInstance("customer");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("customer.add");
                ToolBar::_clone("customer.clone_list");
                ToolBar::delete("customer.delete_list");
                $model = Model::getInstance("customers");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit Customer');
                ToolBar::save('customer.save');
                ToolBar::back_to_list('customer.back_to_list');
                ToolBar::cancel('customer.cancel');
                ToolBar::apply('customer.apply');
                $id = $input->getInt('id', 0);
                $this->item = $modelCustomer->getItem($id);
                $this->form = $modelCustomer->getForm();
                break;
        }
        return parent::display($tpl);
    }
}