<?php

use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Utilities\Utility as UtilityAlias;
use TourOperatorProAdmin\app\Html\HtmlBackend;
$doc = FactoryAlias::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_customers.less');
TourOperatorProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List Customer");
TourOperatorProHtmlBackendAlias::load_jquery_library('datatables');

?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("currencies.form")) ?>" name="admin-form" method="post">
        <div class="container">
            <h4>Supported currencies.</h4>
            <button type="button" class="btn btn-info btn-lg" data-toggle="modal" data-target="#myModal">View Currencies</button>
            <div class="modal fade" id="myModal" role="dialog">
                <div class="modal-dialog">

                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                            <h4 class="modal-title">List Currencies</h4>
                            <strong style="color: red">based on <?php echo ($this->list_currencies_api['base'])?> rate</strong>
                        </div>
                        <div class="modal-body">
                            <table class="table table-bordered">
                                <thead>
                                <tr>
                                    <th>Code Currencies</th>
                                    <th>Rates</th>
                                </tr>
                                </thead>
                            <?php foreach ($this->list_currencies_api['rates'] as $key => $value) {?>
                                <tbody>
                                <tr>
                                    <td><?php echo ($key)?></td>
                                    <td><?php echo ($value)?></td>
                                </tr>
                                </tbody>
                            <?php } ?>
                            </table>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>

                </div>
            </div>

        </div>
        <h3>based on the exchange rate of the currency <?php echo ($this->list_currencies_api['base'])?></h3>
        <div class="view-list-currencies">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_attr_e('Index','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Name','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Code','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Symbol','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Rate','touroperatorpro'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id))?></td>
                        <td class="customer-name"><?php echo ($item->name); ?> </td>
                        <td class="customer-code"><?php echo ($item->code); ?></td>
                        <td class="customer-symbol"><?php echo ($item->symbol); ?></td>
                        <?php foreach ($this->list_currencies_api['rates'] as $key => $value) {
                            if ($item->code == $key){ ?>
                                <td class="customer-rate"><?php echo ($value); ?></td>
                            <?php } ?>
                        <?php } ?>
                        <td class="customer-action">
                            <a href="<?php echo(UtilityAlias::getBackendGoToLink("currencies.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','touroperatorpro')?>"><i class="fas fa-edit"></i> </a>
                            <a href="<?php echo(UtilityAlias::goToTaskByView("currencies","currencies.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','touroperatorpro')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="currency.save">
    </form>
<?php
$doc->addScriptApplySelector('.view-list-customers', 'view_list_customers', array(), "admin_woopanel/app/assets/js/view_list_customers.js");
?>