<?php

namespace TourOperatorProAdmin\app\views\currencies;

use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Mvc\View\View;
use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorProAdmin\app\helpers\CurrencyHelper;

class CurrenciesView extends View
{
    public function display($tpl)
    {
        $modelCustomer = Model::getInstance("currency");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("currency.add");
                ToolBar::_clone("currency.clone_list");
                ToolBar::delete("currency.delete_list");
                $model = Model::getInstance("currencies");
                $this->list = $model->getList();
                $this->list_currencies_api = CurrencyHelper::getRatesCurrenciesbyAPI();
                break;
            case "form":
                ToolBar::setTitle('Edit Currency');
                ToolBar::save('currency.save');
                ToolBar::back_to_list('currency.back_to_list');
                ToolBar::cancel('currency.cancel');
                ToolBar::apply('currency.apply');
                $id = $input->getInt('id', 0);
                $this->item = $modelCustomer->getItem($id);
                $this->form = $modelCustomer->getForm();
                break;
        }
        return parent::display($tpl);
    }
}