<?php

namespace TourOperatorProAdmin\app\views\coupon;

use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Mvc\View\View;
use TourOperatorPro\Factory as FactoryAlias;

class CouponView extends View
{
    public function display($tpl)
    {

        $modelcoupon = Model::getInstance("coupon");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("coupon.add");
                ToolBar::delete("coupon.delete_list");
                ToolBar::_clone("coupon.clone_list");
                $model = Model::getInstance("coupons");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit coupon');
                ToolBar::apply("coupon.apply");
                ToolBar::save("coupon.save");
                ToolBar::cancel("coupon.cancel");
                ToolBar::back_to_list("coupon.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelcoupon->getItem($id);
                $this->form = $modelcoupon->getForm();

                break;
        }
        return parent::display($tpl);
    }
}