<?php

use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Utilities\Utility as UtilityAlias;
use TourOperatorPro\Language\Text;
use TourOperatorProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
TourOperatorProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List countries");
TourOperatorProHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("countries.form")) ?>" name="admin-form" method="post">
        <div class="view-list-countries">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_attr_e('Index','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Country name','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Country code','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Flag','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Publish','touroperatorpro'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="country-name">
                            <h4>
                                <?php echo ($item->countryname); ?>
                            </h4>
                        </td>
                        <td class="country-code"><?php  esc_html_e($item->countrycode); ?> </td>
                        <td class="country-flag">
                            <img src="<?php  echo(FactoryAlias::getRootUrlPlugin().'/'.$item->image) ?>" alt="flag">
                        </td>
                        <td class="country-published">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="Public"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="Not-Public"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="country-action">
                            <a href="<?php echo(UtilityAlias::getBackendGoToLink("countries.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','touroperatorpro')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByView("countries","country.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','touroperatorpro')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_countries.less');
$doc->addScriptApplySelector('.view-list-countries', 'view_list_countries', array(

), "admin/app/assets/js/view_list_countries.js");
?>