<?php
namespace TourOperatorProAdmin\app\models;
defined('_TOUROPERATOR_EXEC') or die;

use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\ModelForm;
use TourOperatorPro\Form\Form;
use TourOperatorPro\Mvc\Model\ModelList;
use TourOperatorPro\Registry\Registry;
use TourOperatorProAdmin\app\helpers\AdminHelper;
class ToursModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "tours";
    /**
     * @var string
     */
    public $table_name = "tour";
    public function getListQuery()
    {
        $query=$this->db->getQuery(true);
        $query->select("a.*")
            ->from($this->getTableName().' AS a')

        ;
        $query->order('a.id DESC');

        return $query;
    }
    public function getList()
    {
        $db=Factory::getDBO();
        $query=$this->getListQuery();
        $list_tour = $db->setQuery($query)->loadObjectList();
        foreach ($list_tour as &$tour){
            $query->clear()
                ->select('DISTINCT tourtype.*')
                ->from($this->getTableName('tourproperty').' AS tourproperty')
                ->leftJoin($this->getTableName('tourtype').' AS tourtype ON tourtype.id=tourproperty.object_id')
                ->where('tour_id='.(int)$tour->id)
                ->where('type='.$query->quote(AdminHelper::getTourTypeKey()))
            ;
            $list_tour_type= $this->_db->setQuery($query)->loadObjectList();
            $tour->list_tour_type=$list_tour_type;

            $query->clear()
                ->select('DISTINCT location.*')
                ->from($this->getTableName('tourproperty').' AS tourproperty')
                ->leftJoin($this->getTableName('location').' AS location ON location.id=tourproperty.object_id')
                ->where('tour_id='.(int)$tour->id)
                ->where('type='.$query->quote(AdminHelper::getTourDestinationKey()))
            ;
            $list_destination= $this->_db->setQuery($query)->loadObjectList();
            $tour->list_destination=$list_destination;
        }
        return $list_tour;
    }

    public function get_list_tour_in_year()
    {
        $now = Factory::getDate();
        $now1 = $now->modify('-12 month');
        $query = $this->_db->getQuery(true);
        $query->select('tour.*')
            ->select('MONTH(tour.created_date) AS month')
            ->from($this->getTableName('tour') . ' AS tour')
            ->where('tour.created_date>=' . $query->quote($now1->toSql()));
        $list = $this->_db->setQuery($query)->loadObjectList();
        return $list;
    }

}
