<?php
namespace TourOperatorProAdmin\app\models;
defined('_TOUROPERATOR_EXEC') or die;

use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\ModelForm;
use TourOperatorPro\Filesystem\File as FileAlias;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Form\Form;
use TourOperatorPro\Mvc\Model\ModelList;
use TourOperatorPro\Registry\Registry;
use TourOperatorPro\Utilities\Utility;

class OrderModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "order";
    /**
     * @var string
     */
    public $table_name = "order";
    
    public function save($data = array())
    {
        $item =  parent::save($data); // TODO: Change the autogenerated stub
        return $item;
    }
    public function save_order_edit($data){
        $customer_id = $data['customer_id'];
        $first_name = $data['first_name'];
        $last_name = $data['last_name'];
        $mobile = $data['mobile'];
        $form_datetime = $data['form_datetime'];
        $description = $data['description'];
        $customerModel = Model::getInstance('customer');
        $data_customer = [
            'id' => $customer_id,
            'first_name'=>$first_name,
            'last_name'=>$last_name,
            'mobile'=>$mobile,
            'created_date'=>$form_datetime,
            'note_internal'=>$description,
        ];
        $customer = $customerModel->save($data_customer);
        $tour_id = $data['tour_id'];
        $ordertail_id = $data['ordertail_id'];
        $adult_number = $data['adult_number'];
        $children_number = $data['children_number'];
        $infant_number = $data['infant_number'];
        $tourModel = Model::getInstance('tour');
        $tour = $tourModel->getItem($tour_id);
        $total_price = $total = (int)$adult_number * (float)$tour->adult_price
            + (int)$children_number * (float)$tour->children_price
            + (int)$infant_number * (float)$tour->infant_price;
        $orderdetailModel = Model::getInstance('orderdetail');
        $data_orderdetail = [
            'id'=>$ordertail_id,
            'adult'=>$adult_number,
            'children'=>$children_number,
            'infant'=>$infant_number,
            'total'=>$total_price,
        ];
        $ordertail = $orderdetailModel->save($data_orderdetail);
        $order_status_id = $data['order_status_id'];
        $order_id = $data['id'];
        $orderModel = Model::getInstance('order');
        $data_order = [
            'id'=>$order_id,
            'order_status_id'=>$order_status_id,
        ];
        $order = $orderModel->save($data_order);
        return $order;
    }


    public function getItem($id = 0)
    {
        $item= parent::getItem($id); // TODO: Change the autogenerated stub
        if(isset($item->id) && $item->id !=0) {
            $query = $this->db->getQuery(true);
            $query->select('order_detail.*')
                ->from($this->getTableName('order_detail') . ' AS order_detail')
                ->where('order_detail.order_id=' . (int)$item->id);
            $item->order_detail = $this->db->setQuery($query)->loadObject();
            $query->clear();
            $query->select('customer.*')
                ->select('customer.countryname')
                ->from($this->getTableName('customer') . ' AS customer')
                ->select("country.countryname")
                ->from($this->getTableName('country') . ' AS country')
                ->select("country.countryname AS countryname")
                ->where('country.code=customer.countryname')
                ->where('customer.id=' . (int)$item->customer_id);
            $item->customer = $this->db->setQuery($query)->loadObject();
            if( $item->customer)
            {
                $item->customer->full_name=Utility::get_full_name($item->customer->first_name,$item->customer->last_name);
            }
            $query->clear();
            $query->select('tour.*')
                ->from($this->getTableName('tour') . ' AS tour')
                ->where('tour.id=' . (int)$item->order_detail->tour_id);
            $item->tour = $this->db->setQuery($query)->loadObject();
        }
        return $item;
    }


}
