<?php
namespace TourOperatorProAdmin\app\models;
defined('_TOUROPERATOR_EXEC') or die;

use Exception;
use TourOperatorPro\Factory;
use TourOperatorPro\Filesystem\File as FileAlias;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Mvc\Model\ModelForm;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Form\Form;
use TourOperatorPro\Mvc\Model\ModelList;
use TourOperatorPro\Registry\Registry;
use TourOperatorPro\Utilities\Utility;

class FacilityModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "facility";
    /**
     * @var string
     */
    public $table_name = "facility";



    public function save($data = array())
    {
        $item= parent::save($data); // TODO: Change the autogenerated stub
        $image=Factory::getInput()->files->get('image','','raw');
        if(!empty($image['name'])) {
            $name = str_replace(' ', '_',Utility::gen_random_string()) . $image['name'];
            $short_path_image = "upload/facilities/images/cover/$name";
            $new_file_image_facility_path = TOUROPERATORPRO_PATH_ROOT . DS . $short_path_image;
            if (!FileAlias::write($new_file_image_facility_path, FileAlias::read($image['tmp_name']))) {
                throw new Exception(Text::_("can not upload image cover"));
            }
            $item->image = $short_path_image;
            $data = (array)$item;
            $item = parent::save($data);
        }
        $galleryModel=Model::getInstance('gallery');
        $gallery=Factory::getInput()->files->get('gallery','','raw');
        if($gallery && count($gallery["name"]))for($i=0;$i<count($gallery["name"]);$i++){
            $name = str_replace(' ', '_',Utility::gen_random_string()) . $gallery['name'][$i];
            $short_path_image = "upload/gallery/facilities/$name";
            $new_file_image_facility_path = TOUROPERATORPRO_PATH_ROOT . DS . $short_path_image;
            if (!FileAlias::write($new_file_image_facility_path, FileAlias::read($gallery['tmp_name'][$i]))) {
                throw new Exception(Text::_("can not upload image gallery"));
            }

            $item->gallery[] = $short_path_image;

            $data_gallery=array(
                "id"=>0,
                "type"=>"facility",
                "object_id"=>$item->id,
                "path"=>$short_path_image,
                "name"=>$gallery['name'][$i],
            );
            $galleryModel->save($data_gallery);
        }
        if(isset($data['list_image_gallery_deleted'])) {
            $list_image_gallery_deleted = $data['list_image_gallery_deleted'];
            $list_image_gallery_deleted = (array)json_decode($list_image_gallery_deleted);
        }else{
            $list_image_gallery_deleted=array();
        }
        if(count($list_image_gallery_deleted))foreach ($list_image_gallery_deleted as $id){
            $galleryModel->delete($id);
        }
        return $item;


    }
    public function getItem($id = 0)
    {
        $db=$this->_db;
        $query=$db->getQuery(true);
        $facility= parent::getItem($id); // TODO: Change the autogenerated stub
        if(isset($facility->id)&& $facility->id!=0){
            $query->clear()
                ->select('DISTINCT gallery.*')
                ->from($this->getTableName('gallery').' AS gallery')
                ->where('object_id='.(int)$facility->id)
                ->where('type='.$query->quote('facility'))
                ;
            $list_image= $this->_db->setQuery($query)->loadObjectList();
            $facility->gallery=$list_image;
        }
        return $facility;
    }
}
