<?php
namespace TourOperatorProAdmin\app\models;
defined('_TOUROPERATOR_EXEC') or die;

use TourOperatorPro\Factory;
use TourOperatorPro\Filesystem\File as FileAlias;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Mvc\Model\ModelForm;
use TourOperatorPro\Form\Form;
use TourOperatorPro\Mvc\Model\ModelList;
use TourOperatorPro\Registry\Registry;
use Exception;
/**
 * Class EmailModel
 */
class EmailaccountModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "emailaccount";
    /**
     * @var string
     */
    public $table_name = "emailaccount";
    public function save($data = array())
    {
        if ($data){
            $err = array();
            if ($data['mailer'] == '' || $data['mailer'] == 'Enter your mailer') $err['mailer'] = 'Mailer is required';
            if ($data['port'] == '' || $data['port'] == 'Enter your port') $err['port'] = 'Port is required';
            if ($data['host'] == '' || $data['host'] == 'Enter your host') $err['host'] = ' host is required';
            if ($data['username'] == '' || $data['username'] == 'Enter your username') $err['username'] = 'Gmail  is required';
            if ($data['password'] == '' || $data['password'] == 'Enter your password') $err['password'] = 'Password  is required';
            if (empty($err)){
                $item =  parent::save($data); // TODO: Change the autogenerated stub
            }else{
                $er = (object)$err;
                throw new Exception(Text::_echo(
                    '<div class="alert alert-danger" style="width: 30%; margin: 0 auto; text-align: center">
                        '.((!empty($er->mailer)) ?'<strong>'.$er->mailer.'</strong></br>' : false) .'
                        '.((!empty($er->port)) ?'<strong>'.$er->port.'</strong></br>' : false) .'
                        '.((!empty($er->host)) ?'<strong>'.$er->host.'</strong></br>' : false) .'
                        '.((!empty($er->username)) ?'<strong>'.$er->username.'</strong></br>' : false) .'
                        '.((!empty($er->password)) ?'<strong>'.$er->password.'</strong></br>' : false) .'
                </div>'
                ));
            }
        }
        return $item;
    }

}