<?php
namespace TourOperatorProAdmin\app\models;
defined('_TOUROPERATOR_EXEC') or die;

use TourOperatorPro\Factory;
use TourOperatorPro\Filesystem\File as FileAlias;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Mvc\Model\ModelForm;
use TourOperatorPro\Form\Form;
use TourOperatorPro\Mvc\Model\ModelList;
use TourOperatorPro\Registry\Registry;
use Exception;
/**
 * Class EmailModel
 */
class EmailModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "email";
    /**
     * @var string
     */
    public $table_name = "email";
    
    public function save($data = array())
    {
        if ($data){
            $err = array();
            if ($data['name'] == '' || $data['name'] == 'Enter your name') $err['name'] = 'name is required';
            if ($data['subject'] == '' || $data['subject'] == 'Enter your subject') $err['subject'] = 'Subject is required';
            if ($data['type'] == '' || $data['type'] == 'Enter your subject') $err['type'] = 'Type is required';
            if ($data['content'] == '' || $data['content'] == 'Enter your subject') $err['content'] = 'Content is required';
            if (empty($err)){
                $item = parent::save($data); // TODO: Change the autogenerated stub
            }else{
                $er = (object)$err;
                throw new Exception(Text::_echo(
                    '<div class="alert alert-danger" style="width: 30%; margin: 0 auto; text-align: center">
                        '.((!empty($er->name)) ?'<strong>'.$er->name.'</strong></br>' : false) .'
                        '.((!empty($er->subject)) ?'<strong>'.$er->subject.'</strong></br>' : false) .'
                        '.((!empty($er->type)) ?'<strong>'.$er->type.'</strong></br>' : false) .'
                        '.((!empty($er->content)) ?'<strong>'.$er->content.'</strong></br>' : false) .'
                </div>'
                ));
            }

        }
        return $item;
    }

}