<?php
namespace TourOperatorProAdmin\app\models;
defined('_TOUROPERATOR_EXEC') or die;

use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\ModelForm;
use TourOperatorPro\Form\Form;
use TourOperatorPro\Mvc\Model\ModelList;
use TourOperatorPro\Registry\Registry;
use TourOperatorProFrontend\app\helpers\FrontendHelper;

class DiscountsModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "discounts";
    /**
     * @var string
     */
    public $table_name = "discount";

    public function getList()
    {
        $list_discount =  parent::getList(); // TODO: Change the autogenerated stub
        foreach ($list_discount as &$discount) {
            $query = $this->_db->getQuery(true);
            $query->clear()
                ->select('DISTINCT tour.*')
                ->from($this->getTableName('tour').' AS tour')
                ->leftJoin($this->getTableName('tourproperty').' AS tour_property ON tour_property.tour_id=tour.id')
                ->where('tour_property.object_id='.(int)$discount->id)
                ->where('tour_property.type='.$query->quote(FrontendHelper::getTourDiscountKey()))
                ;
            $discount->list_tour=$this->_db->setQuery($query)->loadObjectList();
        }
        return $list_discount;
    }

}
