<?php
namespace TourOperatorProAdmin\app\models;
defined('_TOUROPERATOR_EXEC') or die;

use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\ModelForm;
use TourOperatorPro\Filesystem\File as FileAlias;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Form\Form;
use TourOperatorPro\Mvc\Model\ModelList;
use TourOperatorPro\Registry\Registry;
use TourOperatorProAdmin\app\helpers\AdminHelper;
use TourOperatorProAdmin\app\helpers\DiscountHelper;

class DiscountModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "discount";
    /**
     * @var string
     */
    public $table_name = "discount";

    public function save($data = array())
    {

        $item= parent::save($data); // TODO: Change the autogenerated stub
        $key_discount=AdminHelper::getTourDiscountKey();
        if(isset($data['tour_id'])) {
            AdminHelper::deletePropertyByKey($key_discount,$item->id);
            $data_tour_id=$data['tour_id'];
            DiscountHelper::insertNewPropertyByKey($key_discount,$data_tour_id, $item->id);
            $item->{$key_tour}=$item->id;
        }
        return $item;
    }
    public function getItem($id = 0)
    {
        $db=$this->_db;
        $query=$db->getQuery(true);
        $discount= parent::getItem($id); // TODO: Change the autogenerated stub
        if (isset($discount->id) && $discount->id!=0){
            $query->clear()
                ->select('DISTINCT tour_property.tour_id')
                ->from($this->getTableName('tourproperty'.' AS tour_property'))
                ->where('object_id='.(int)$discount->id)
                ->where('type='.$query->quote(AdminHelper::getTourDiscountKey()))
                ;
            $list_tour=$this->_db->setQuery($query)->loadColumn();
            $discount->tour_id=$list_tour;
        }
        return $discount;
    }


}
