<?php
namespace TourOperatorProAdmin\app\models;
defined('_TOUROPERATOR_EXEC') or die;

use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\ModelForm;
use TourOperatorPro\Form\Form;
use TourOperatorPro\Mvc\Model\ModelList;
use TourOperatorPro\Registry\Registry;
class DestinationsModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "destinations";
    /**
     * @var string
     */
    public $table_name = "destination";


    public function getList()
    {

        $db = Factory::getDBO();
        $query = $db->getQuery(true)
            ->select("location.*")
            ->from($this->getTableName('location').' AS location')
            ->leftJoin($this->getTableName('state').' AS state ON state.id=location.state_id')
            ->select('state.name AS state_name')
            ->leftJoin($this->getTableName('country'). ' AS country ON country.id=state.country_id')
            ->select('country.countryname AS country_name')
            ->order('location.id DESC');
        return $db->setQuery($query)->loadObjectList();

    }

}
