<?php
namespace TourOperatorProAdmin\app\models;
defined('_TOUROPERATOR_EXEC') or die;

use TourOperatorPro\Factory;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Mvc\Model\ModelForm;
use TourOperatorPro\Filesystem\File as FileAlias;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Form\Form;
use TourOperatorPro\Mvc\Model\ModelList;
use TourOperatorPro\Registry\Registry;
use TourOperatorPro\Utilities\Utility;

class CustomizeModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "customize";
    /**
     * @var string
     */
    public $table_name = "customize";

    public function save($data = array())
    {
        $is_new=!$data["id"];
        $item= parent::save($data); // TODO: Change the autogenerated stub
        if($is_new){
            $db=Factory::getDBO();
            $table=Utility::getTableName($item->table_view);
            switch ($item->type){
                case "boolean":
                    $db->setQuery("ALTER TABLE {$table} ADD `{$item->field_name}` INT NOT NULL;")->execute();
                    break;
                case "select":
                case "text":
                    $db->setQuery("ALTER TABLE {$table} ADD `{$item->field_name}` VARCHAR(255) NOT NULL;")->execute();
                    break;

            }
        }
        return $item;
    }


}
