<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Utilities\Utility;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
defined('_TOUROPERATOR_EXEC') or die;
extract($displayData);

TourOperatorProHtmlBackendAlias::load_jquery_library('select2');


$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$modelTourtypes = Model::getInstance('tourtypes');
$list = $modelTourtypes->getList_tourtype_public();
$list_time = [];
$list_tour_type_id = [];
if (!is_array($value)) {
	$list_tour_type_id[] = $value;
} else {
	$list_tour_type_id = $value;
}
?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="<?php esc_attr_e($class); ?> field-tourtype">
        <select name="<?php esc_attr_e($name); ?>"
                required="<?php esc_attr_e($required) ?>" <?php echo ($multiple ? ' multiple ' : ""); ?>
                class="list-tour-type">
            <option value=""><?php esc_html_e('Select tour type','touroperatorpro') ?></option>
			<?php foreach ($list as $item) { ?>
                <option <?php echo (in_array($item->id, $list_tour_type_id) ? ' selected ' : null) ?>
                        value="<?php esc_attr_e($item->id); ?>"><?php esc_html_e($item->name); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/tourtype/tourtype.less');
$doc->addScriptApplySelector('.field-tourtype','field_tourtype',array(
),'admin/app/layouts/WooBooking/form/field/tourtype/tourtype.jquery.js');