<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Utilities\Utility;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
defined('_TOUROPERATOR_EXEC') or die;
extract($displayData);
TourOperatorProHtmlBackendAlias::load_jquery_library('select2');
$id_by_name = "element_field_". $name;
$modelSmses = Model::getInstance('smses');
$list = $modelSmses->getList();
$data = $displayData['field']->getForm()->getData();
$uri = Factory::getUri();
$list_page_id = [];
if (!is_array($value)) {
    $list_page_id[] = $value;
} else {
    $list_page_id = $value;
}




?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="<?php esc_attr_e($class); ?> field-smssuplier">
        <select name="<?php echo (esc_attr($name)); ?>"
                required="<?php echo (esc_attr($required)) ?>" <?php echo ($multiple ? ' multiple ' : ""); ?>
                class="list-page">
            <option value=""><?php esc_html_e('Select SMS SUPPLIER','touroperatorpro') ?></option>
            <?php foreach ($list as $item) { ?>
                <option <?php echo $item->id ? ' selected ' : null ?>
                    value="<?php echo (esc_attr($item->id)); ?>"><?php echo (esc_html(str_replace("_"," ",$item->phone_register))); ?></option>
            <?php } ?>
        </select>
    </div>
<?php

$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/smssuplier/smssuplier.less');
$doc->addScriptApplySelector('.field-smssuplie','field_smssuplie',array(
),'admin/app/layouts/WooBooking/form/field/smssuplier/smssuplier.jquery.js');