<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Utilities\Utility;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Language\Text;
defined('_TOUROPERATOR_EXEC') or die;
extract($displayData);
TourOperatorProHtmlBackendAlias::load_jquery_library('moment');
TourOperatorProHtmlBackendAlias::load_jquery_library('daterangepicker');


$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/rates/rates.less');
$id_by_name = "element_field_". $name;

$modelTour  = Model::getInstance('tour');
$input = Factory::getInput();
$tour_id = $input->getInt('id', 0);
$tour = $modelTour->getItem($tour_id);
$list_rate = isset($tour->list_rate)?$tour->list_rate:array();
$template_rate = function ($name_check_in,$date_check_in,$name_check_out, $date_check_out){
    ob_start();
    ?>
    <div class="wrapper-item-rate">
        <div class="input-date input-date-checkin">
            <input type="text" class="check-in" value="<?php echo (esc_attr($date_check_in));?>">
            <i class="far fa-calendar-alt"></i>
            <input type="hidden" name="<?php echo($name_check_in.'[]');?>" value="<?php echo (esc_attr($date_check_in));?>">
        </div>
        <div class="input-date input-date-checkout">
            <input type="text" class="check-out" value="<?php echo (esc_attr($date_check_out));?>">
            <i class="far fa-calendar-alt"></i>
            <input type="hidden" name="<?php echo($name_check_out.'[]');?>" value="<?php echo (esc_attr($date_check_out));?>">
        </div>
        <div class="button-action">
            <button type="button" class="btn btn-primary btn-add-rate"><i class="far fa-copy"></i></button>
            <button type="button" class="btn btn-danger btn-delete-rate"><i class="far fa-trash-alt"></i></button>
        </div>
    </div>
    <?php
    $content = ob_get_clean();
    return $content;
}
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="field-rates">
        <?php
            if(count($list_rate) == 0) {
                echo($template_rate($name_check_in,null,$name_check_out,null));
            } else {
                foreach ($list_rate as $rate) {
                    echo($template_rate($name_check_in, $rate->from, $name_check_out, $rate->to));
                }

            }
        ?>
    </div>
<?php
$doc->addScriptApplySelector("#$id_by_name",'field_rates',array(
    "input_name"=>  $name,
    "item_rate"=>$template_rate($name_check_in,null,$name_check_out,null),
    "field_name_check_in"=>$name_check_in,
    "field_name_check_out"=>$name_check_out,
    "list_rate"=>$list_rate
),'admin/app/layouts/WooBooking/form/field/rates/jquery.rates.js');
