"use strict";
(function ($) {
    $.field_rate = function (element, options) {
        var defaults = {
            values: [],
            max_rate: 10
        }
        var plugin = this;
        plugin.settings = {};
        var $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let max_rate = plugin.settings.max_rate;
            let values = plugin.settings.values;
            if (values.length > 0) {
                $.each(values, function (index, rate) {
                    plugin.set_daterangepicker($($element.find('.list-item input.rate')[index]), rate);
                });
            } else {
                plugin.set_daterangepicker($element.find('.list-item input.rate'));
            }
            $element.find('.btn-add').on('click',function (e) {
                plugin.set_task_when_click();
            });
            $element.find('.list-item>.item').each(function (e) {
                let $rate_item = $(this);
                plugin.init_event_rate_item($rate_item);
            });
        };
        plugin.set_daterangepicker = function ($input_element, rate) {
            $input_element.daterangepicker({
                opens: 'left',
                timePicker: true,
                startDate: (typeof rate !== "undefined" && rate.from !== "") ? moment(rate.from).startOf('minute') : moment().startOf('minute'),
                endDate: (typeof rate !== "undefined" && rate.to !== "") ? moment(rate.to).startOf('minute') : moment().startOf('minute').add(32, 'minute'),
                locale: {
                    format: 'M/DD/YYYY hh:mm A'
                },
                isInvalidDate: function(date) {
                    if (date.format('YYYY-MM-DD') < moment().format('YYYY-MM-DD')) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }, function (start, end, label) {
                $input_element = $(this.element);
                let $item = $input_element.closest('.item');
                let rate = `${start.format('YYYY-MM-DD hh:mm:ss')};${end.format('YYYY-MM-DD hh:mm:ss')}`;
                $item.find(`input[name="${plugin.settings.input_name}"]`).val(rate);
            });
        };
        plugin.init_event_rate_item = function ($rate_item) {
            $rate_item.find('.btn-close-item').on('click',function (e) {
                if ($element.find('.list-item .item').length > 1) {
                    $element.find('.list-item .item:last-child').remove();
                }
            })
        };
        plugin.set_task_when_click = function () {
            let max_rate = plugin.settings.max_rate;
            max_rate = parseInt(max_rate);
            let total_current_rate = $element.find('.list-item .item').length;
            if (total_current_rate >= max_rate) {
                $.alert({
                    title: 'Error',
                    content: `you cannot add more than ${max_rate} `
                });
                return;
            }
            var $item_rate = $(plugin.settings.item_rate);
            $item_rate.appendTo($element.find('.list-item'));
            plugin.set_daterangepicker($item_rate.find('input.rate'));
            $item_rate.find('.btn-add').on('click',function (e) {
                plugin.set_task_when_click();
            });
            plugin.init_event_rate_item($item_rate);
        }
        plugin.example_function = function () {
        };
        plugin.init();
    }
    
    $.fn.field_rate = function (options) {
        
        return this.each(function () {
            
            if (undefined == $(this).data('field_rate')) {
                var plugin = new $.field_rate(this, options);
                $(this).data('field_rate', plugin);
            }
        });
    }
})(jQuery);