<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Utilities\Utility;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
defined('_TOUROPERATOR_EXEC') or die;
extract($displayData);

TourOperatorProHtmlBackendAlias::load_jquery_library('select2');
$id_by_name = "element_field_". $name;
$modelCountry = Model::getInstance('countries');
$list = $modelCountry->getList();
foreach ($list as &$item) {
	$item->text = $item->countrycode;
}
$data = $displayData['field']->getForm()->getData();
$uri = Factory::getUri();
if($uri->getVar('page','') == 'wb_employee' && $uri->getVar('id',0) > 0) {
    $modelEmployee = Model::getInstance('employee');
    $employee = $modelEmployee->getItem($uri->getVar('id',0));
    $phone_code = $employee->phonecode;
    $current_country = $employee->country_name;
    $country_code = $employee->countrycode;
} elseif ($uri->getVar('page','') == 'wb_customers' && $uri->getVar('id',0) > 0) {
    $modelCustomer = Model::getInstance('customer');
    $customer = $modelCustomer->getItem($uri->getVar('id',0));
    $phone_code = $customer->phonecode;
    $current_country = $customer->country_name;
    $country_code = $customer->country_code;
} elseif ($uri->getVar('page','') == 'wb_sms' && $uri->getVar('id',0) > 0) {
    $modelSms = Model::getInstance('sms');
    $sms = $modelSms->getItem($uri->getVar('id',0));
    $phone_code = $sms->phonecode;
    $current_country = $sms->country_name;
    $country_code = $sms->countrycode;
}  elseif ($uri->getVar('page','') == 'wb_service' && $uri->getVar('id',0) > 0) {
    $modelService = Model::getInstance('service');
    $service = $modelService->getItem($uri->getVar('id',0));
    $phone_code = $service->phonecode;
    $current_country = $service->country_name;
    $country_code = $service->countrycode;
}  elseif ($uri->getVar('page','') == 'wb_destinations' && $uri->getVar('id',0) > 0) {
    $modelLocation = Model::getInstance('destination');
    $location = $modelLocation->getItem($uri->getVar('id',0));
    $phone_code = $location->phonecode;
    $current_country = $location->country_name;
    $country_code = $location->countrycode;
}  else {
    $phone_code = $default_phone_code;
    $current_country="United States";
    $country_code = "USA";
}



?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="<?php esc_attr_e($class); ?> field-phonenumber">
        <div class="wrapper-phone-number">
            <input class="countries" value="" type="text">
            <input type="hidden" name="<?php echo (esc_attr($field_name_phone_code)) ?>" value="<?php esc_attr_e($phone_code) ?>">
            <input type="hidden" name="<?php echo (esc_attr($field_name_countrycode)) ?>" value="<?php esc_attr_e($country_code) ?>">
            <input class="phone_number" name="<?php esc_attr_e($name); ?>" value="<?php esc_attr_e($value) ?>"
                   type="text">
        </div>
    </div>
<?php

$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/phonenumber/phonenumber.less');
$doc->addScriptApplySelector('.field-phonenumber','field_phonenumber',array(
    "input_name"=>  $name,
    "list_country"=>  $list,
    "field_name_phone_code"=>$field_name_phone_code,
    "field_name_countrycode"=>$field_name_countrycode,
    "phonecode"=>$phone_code,
    "current_country"=>$current_country,
    "countrycode"=>$country_code,
),'frontend/app/layouts/WooBooking/form/field/phonenumber/phonenumber.jquery.js');