<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Utilities\Utility;
defined('_TOUROPERATOR_EXEC') or die;
extract($displayData);
TourOperatorProHtmlBackendAlias::load_jquery_library('select2');


$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$list = get_pages();
$list_time = [];
$list_page_id = [];
if (!is_array($value)) {
	$list_page_id[] = $value;
} else {
	$list_page_id = $value;
}



?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-pages">
        <select name="<?php echo (esc_attr($name)); ?>"
                required="<?php echo (esc_attr($required)) ?>" <?php echo ($multiple ? ' multiple ' : ""); ?>
                class="list-page">
            <option value=""><?php esc_html_e('Select page','touroperatorpro') ?></option>
			<?php foreach ($list as $item) { ?>
                <option <?php echo (in_array($item->ID, $list_page_id) ? ' selected ' : null) ?>
                        value="<?php echo (esc_attr($item->ID)); ?>"><?php echo (esc_html($item->post_title)); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/pages/pages.less');
$doc->addScriptApplySelector('.field-pages','field_pages',array(
),'admin/app/layouts/WooBooking/form/field/pages/pages.jquery.js');