<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Utilities\Utility;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
defined('_TOUROPERATOR_EXEC') or die;
defined('_TOUROPERATOR_EXEC') or die;
extract($displayData);

TourOperatorProHtmlBackendAlias::load_jquery_library('select2');


$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$modelitineraries = Model::getInstance('tour');
$list = $modelitineraries->getItem();
$list_time = [];
$list_country_id = [];
if (!is_array($value)) {
	$list_country_id[] = $value;
} else {
	$list_country_id = $value;
}
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-itineraries">
        <div class="list-itineraries">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Title</th>
                        <th>Description</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($list->itineraries as $item){ ?>
                        <tr>
                            <td><?php esc_html_e($item->name)?></td>
                            <td></td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/itineraries/itineraries.less');
$doc->addScriptApplySelector('.field-itineraries','field_itineraries',array(
),'admin/app/layouts/WooBooking/form/field/itineraries/itineraries.jquery.js');