<?php
defined('_TOUROPERATOR_EXEC') or die;
use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Utilities\Utility;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Language\Text;
extract($displayData);

TourOperatorProHtmlBackendAlias::load_jquery_library('select2');


$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$db=Factory::getDBO();
$fields=$db->getTableColumns(Utility::getTableName('service'));
$list_field_for_content=array();
foreach ($fields as $field=>$type){
    if(strpos($field,"id")===false){
        $list_field_for_content['service'][]="{service_{$field}}";
    }
}
$fields=$db->getTableColumns(Utility::getTableName('order'));

foreach ($fields as $field=>$type){
    $list_field_for_content['order'][]="{order_{$field}}";
}
$fields=$db->getTableColumns(Utility::getTableName('customer'));

foreach ($fields as $field=>$type){
    if(strpos($field,"id")===false){
        $list_field_for_content['customer'][]="{customer_{$field}}";
    }
}
$fields=$db->getTableColumns(Utility::getTableName('order_detail'));

foreach ($fields as $field=>$type){
    if(strpos($field,"id")===false){
        $list_field_for_content['orderdetail'][]="{orderdetail_{$field}}";
    }
}

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-fieldsendsms">
        <div class="row">
            <div class="col-md-3">
                <h4><?php esc_html_e("Service",'wpbookingpro'); ?></h4>
                <ul class="fields">
                    <?php foreach ($list_field_for_content['service'] as $field){ ?>
                        <li><?php echo (esc_html($field)) ?></li>
                    <?php } ?>
                </ul>
            </div>
            <div class="col-md-3">
                <div class="block-location-code">
                    <h4><?php esc_html_e("Location",'wpbookingpro'); ?></h4>
                    <ul class="fields">
                        <li><?php echo (esc_html('{location_i}')); ?></li>
                    </ul>
                </div>
                <div class="block-customer-code">
                    <h4><?php esc_html_e("Customer",'wpbookingpro'); ?></h4>
                    <ul class="fields">
                        <?php foreach ($list_field_for_content['customer'] as $field){ ?>
                            <li><?php echo (esc_html($field)) ?></li>
                        <?php } ?>
                    </ul>
                </div>
            </div>
            <div class="col-md-3">
                <h4><?php esc_html_e("Order",'wpbookingpro'); ?></h4>
                <ul class="fields">
                    <?php foreach ($list_field_for_content['order'] as $field){ ?>
                        <li><?php echo (esc_html($field)) ?></li>
                    <?php } ?>
                </ul>
            </div>
            <div class="col-md-3">
                <h4><?php esc_html_e("Order_detail",'wpbookingpro'); ?></h4>
                <ul class="fields">
                    <?php foreach ($list_field_for_content['orderdetail'] as $field){ ?>
                        <li><?php echo (esc_html($field)) ?></li>
                    <?php } ?>
                </ul>
            </div>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/fieldsendsms/fieldsendsms.less');
$doc->addScriptApplySelector('.field-fieldsendsms','field_fieldsendsms',array(
),'admin/app/layouts/WooBooking/form/field/fieldsendsms/fieldsendsms.jquery.js');