<?php
defined('_TOUROPERATOR_EXEC') or die;
use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Utilities\Utility;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Language\Text;
extract($displayData);

TourOperatorProHtmlBackendAlias::load_jquery_library('select2');


$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$db=Factory::getDBO();
$fields=$db->getTableColumns(Utility::getTableName('tour'));
$list_field_for_content=array();
foreach ($fields as $field=>$type){
    if(strpos($field,"id")===false){
        if (str_replace("image","",$field) && str_replace("alias","",$field) && str_replace("ordering","",$field)) {
            $list_field_for_content['tour'][] = "{tour_{$field}}";
        }
    }
}
$fields=$db->getTableColumns(Utility::getTableName('order'));
foreach ($fields as $field=>$type){
    if (str_replace("ordering","",$field) && str_replace("open_source_order_id","",$field) && str_replace("open_source_order_id","",$field)
    && str_replace("adult_number","",$field) && str_replace("children_number","",$field) && str_replace("infant_number","",$field)
        && str_replace("created_date","",$field) && str_replace("title","",$field) && str_replace("payment_id","",$field)
        && str_replace("staff_id","",$field) && str_replace("alias","",$field) && str_replace("data","",$field)) {
        $list_field_for_content['order'][] = "{order_{$field}}";
    }
}
$fields=$db->getTableColumns(Utility::getTableName('customer'));
foreach ($fields as $field=>$type){
    if(strpos($field,"id")===false) {
        if (str_replace("gender", "", $field) && str_replace("ordering", "", $field)) {
            $list_field_for_content['customer'][] = "{customer_{$field}}";
        }
    }
}
$fields=$db->getTableColumns(Utility::getTableName('order_detail'));
foreach ($fields as $field=>$type){
    if(strpos($field,"id")===false){
        if (str_replace("end_date","",$field)) {
            $list_field_for_content['orderdetail'][] = "{orderdetail_{$field}}";
        }
    }
}
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-fieldsendemail">
        <div class="row">
            <div class="col-md-3">
                <h4><?php esc_html_e("Tour",'touroperatorpro'); ?></h4>
                <ul class="fields">
                    <?php foreach ($list_field_for_content['tour'] as $field){ ?>
                        <li><?php esc_html_e($field) ?></li>
                    <?php } ?>
                </ul>
            </div>
            <div class="col-md-3">
                <div class="block-location-code">
                    <h4><?php esc_html_e("Location",'touroperatorpro'); ?></h4>
                    <ul class="fields">
                        <li><?php esc_attr_e('{location_i}','touroperatorpro') ?></li>
                    </ul>
                </div>
                <div class="block-customer-code">
                    <h4><?php esc_html_e("Customer",'touroperatorpro'); ?></h4>
                    <ul class="fields">
                        <?php foreach ($list_field_for_content['customer'] as $field){ ?>
                            <li><?php esc_html_e($field) ?></li>
                        <?php } ?>
                    </ul>
                </div>
            </div>
            <div class="col-md-3">
                <h4><?php esc_html_e("Order",'touroperatorpro'); ?></h4>
                <ul class="fields">
                    <?php foreach ($list_field_for_content['order'] as $field){ ?>
                        <li><?php esc_html_e($field) ?></li>
                    <?php } ?>
                </ul>
            </div>
            <div class="col-md-3">
                <h4><?php esc_html_e("Order_detail",'touroperatorpro'); ?></h4>
                <ul class="fields">
                    <?php foreach ($list_field_for_content['orderdetail'] as $field){ ?>
                        <li><?php esc_html_e($field) ?></li>
                    <?php } ?>
                </ul>
            </div>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/fieldsendemail/fieldsendemail.less');
$doc->addScriptApplySelector('.field-fieldsendemail','field_fieldsendemail',array(
),'admin/app/layouts/WooBooking/form/field/fieldsendemail/fieldsendemail.jquery.js');