<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Utilities\Utility;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorProAdmin\app\helpers\EmailHelper;
use TourOperatorPro\Language\Text;
defined('_TOUROPERATOR_EXEC') or die;
extract($displayData);

TourOperatorProHtmlBackendAlias::load_jquery_library('select2');


$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$list_email_type=EmailHelper::get_list_email_type();
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-emailtype">
        <select name="<?php echo (esc_attr($name)); ?>"
                class="form-control list-emailtype">
            <option value=""><?php esc_attr_e('Select email type','touroperatorpro')?></option>
            <?php foreach ($list_email_type as $item) { ?>
                <option <?php echo (EmailHelper::check_in_array_mail_type($value) ? " selected " : "") ?>
                        value="<?php echo(esc_attr($item->type)); ?>"><?php esc_html_e($item->description); ?></option>
            <?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/emailtype/emailtype.less');
$doc->addScriptApplySelector('.field-emailtype','field_emailtype',array(
        'field_name'=> $name
),'admin/app/layouts/WooBooking/form/field/emailtype/emailtype.js');