<?php
use TourOperatorPro\Factory;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
defined('_TOUROPERATOR_EXEC') or die;
extract($displayData);

$doc = Factory::getDocument();

$id_by_name = "element_field_". $name;

if($editor_type=="ckeditor") {
    TourOperatorProHtmlBackendAlias::load_jquery_library('ckeditor');

}else {
    $settings = array(
        'media_buttons' => true,
        'quicktags' => array('buttons' => 'em,strong,link,p'),
        'textarea_name' => $name,//name you want for the textarea
        'quicktags' => false,
        'tinymce' => array(
            'toolbar1' => 'formatselect,bold,italic,bullist,numlist,blockquote,alignleft,aligncenter,alignright,link,unlink,wp_more,spellchecker,fullscreen,wp_adv',
            'toolbar2' => 'strikethrough,hr,forecolor,pastetext,removeformat,charmap,outdent,indent,undo,redo,wp_help'
        ),
        'autoresize_min_height' => 250,
        'wp_autoresize_on' => true,
    );


}
?>

<div id="<?php esc_attr_e($id_by_name) ?>" class="field-editor">
    <?php if($editor_type=="ckeditor"){ ?>
        <textarea name="<?php echo esc_attr_e($name) ?>" id="<?php echo esc_attr_e($name) ?>" rows="10" cols="150"><?php echo ($value) ?></textarea>
    <?php }else{ ?>
        <?php wp_editor($value, $name, $settings); ?>
    <?php } ?>
</div>

<?php

$doc->addScriptApplySelector('#'.$id_by_name,'field_editor',array(
    "input_name"=>  $name,
    "editor_type"=>$editor_type
),'admin/app/layouts/WooBooking/form/field/editor/jquery.editor.js');
