<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Utilities\Utility;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
defined('_TOUROPERATOR_EXEC') or die;
extract($displayData);
TourOperatorProHtmlBackendAlias::load_jquery_library('select2');
$id_by_name = "element_field_". $name;
$modelCurrencyList = Model::getInstance('currencies');
$list = $modelCurrencyList->getList();

$data = $displayData['field']->getForm()->getData();
$uri = Factory::getUri();
$list_page_id = [];
if (!is_array($value)) {
    $list_page_id[] = $value;
} else {
    $list_page_id = $value;
}
$type_currency = $default_currency;

?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="<?php esc_attr_e($class); ?> field-smsaction">
        <select name="<?php echo (esc_attr($name)); ?>"
                required="<?php echo (esc_attr($required)) ?>" <?php echo ($multiple ? ' multiple ' : ""); ?>
                class="list-page">
            <option value=""><?php esc_html_e('Select  Currency','touroperatorpro') ?></option>
            <?php foreach ($list as $item) {?>
                <option <?php echo (in_array($item->code, $list_page_id)) ? ' selected ' : reset($type_currency)?>
                        value="<?php echo (esc_attr($item->code)); ?>"><?php echo (esc_html(str_replace(" ","_",$item->name))); ?>
                </option>
            <?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/currencies/currencies.less');
$doc->addScriptApplySelector('.field-emailtypelist','field_emailtypelist',array(),'admin/app/layouts/WooBooking/form/field/currencies/currencies.jquery.js');