<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Utilities\Utility;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Language\Text;
defined('_TOUROPERATOR_EXEC') or die;
extract($displayData);
TourOperatorProHtmlBackendAlias::load_jquery_library('select2');
$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$modelcountries = Model::getInstance('countries');
$list = $modelcountries->getList();
$list_time = [];
$list_country_id = [];
if (!is_array($value)) {
	$list_country_id[] = $value;
} else {
	$list_country_id = $value;
}
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-countries">
        <select name="<?php echo (esc_attr($name)); ?>"
                required="<?php echo (esc_attr($required)) ?>" <?php echo ($multiple ? ' multiple ' : ""); ?>
                class="list-country">
            <option value=""><?php esc_html_e('Select country','touroperatorpro') ?></option>
			<?php foreach ($list as $item) { ?>
                <option <?php  echo (in_array($item->id, $list_country_id) ? ' selected ' : null) ?>
                        value="<?php echo (esc_attr($item->id)); ?>"><?php esc_html_e($item->countryname); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/countries/countries.less');
$doc->addScriptApplySelector('.field-countries','field_countries',array(
),'admin/app/layouts/WooBooking/form/field/countries/countries.jquery.js');